class Tour:
    """
    The tour v_1 -> v_2 -> ... -> v_n is stored as a dictionary
    {v_1:v_2, v_2:v_3, ..., v_(n-1):v_n, v_n:v_1}
    """

    def __init__(self, edges):
        self.edges = edges
        assert set(edges.keys()) == set(edges.values()), edges

    def __eq__(self, other):
        return self.edges == other.edges

    def __hash__(self):
        return hash(tuple(sorted(self.edges.items())))
